/*
 * Decompiled with CFR 0.152.
 */
package org.jdomX;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdomX.Attribute;
import org.jdomX.AttributeList;
import org.jdomX.CDATA;
import org.jdomX.Comment;
import org.jdomX.Content;
import org.jdomX.ContentList;
import org.jdomX.DescendantIterator;
import org.jdomX.Document;
import org.jdomX.EntityRef;
import org.jdomX.FilterIterator;
import org.jdomX.IllegalAddException;
import org.jdomX.IllegalNameException;
import org.jdomX.Namespace;
import org.jdomX.Parent;
import org.jdomX.ProcessingInstruction;
import org.jdomX.Text;
import org.jdomX.Verifier;
import org.jdomX.filter.ElementFilter;
import org.jdomX.filter.Filter;

public class Element
extends Content
implements Parent {
    private static final String CVS_ID = "@(#) $RCSfile: Element.java,v $ $Revision: 1.1.1.1 $ $Date: 2007/06/26 01:25:10 $ $Name:  $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String name;
    protected transient Namespace namespace;
    protected transient List additionalNamespaces;
    AttributeList attributes = new AttributeList(this);
    ContentList content = new ContentList(this);
    int subseqid = -1;
    boolean firstSubseq = true;
    List deepsubseqid = null;
    boolean first = true;
    int sum = 0;

    protected Element() {
    }

    public Element(String name, Namespace namespace) {
        this.setName(name);
        this.setNamespace(namespace);
    }

    public Element(String name, ContentList cntList, AttributeList attList, Namespace ns, List addNS) {
        this.content = cntList;
        this.attributes = attList;
        this.setName(name);
        this.namespace = ns;
        this.additionalNamespaces = addNS;
    }

    public Element(String name) {
        this(name, (Namespace)null);
    }

    public Element(String name, String uri) {
        this(name, Namespace.getNamespace("", uri));
    }

    public Element(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace(prefix, uri));
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String name) {
        String reason = Verifier.checkElementName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        return this;
    }

    public Element setNameF(String nm) {
        String reason = Verifier.checkElementName(nm);
        if (reason != null) {
            throw new IllegalNameException(this.name, "element", reason);
        }
        Element elm = new Element(nm, this.content, this.attributes, this.namespace, this.additionalNamespaces);
        return elm;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        return this;
    }

    public Element setNamespaceF(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        Element newelm = new Element(this.name, this.content, this.attributes, namespace, this.additionalNamespaces);
        return newelm;
    }

    public void morph(Element tgtelm) {
        this.name = tgtelm.name;
        this.content = tgtelm.content;
        this.attributes = tgtelm.attributes;
        this.namespace = tgtelm.namespace;
        this.additionalNamespaces = tgtelm.additionalNamespaces;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (prefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            int i = 0;
            while (i < this.additionalNamespaces.size()) {
                Namespace ns = (Namespace)this.additionalNamespaces.get(i);
                if (prefix.equals(ns.getPrefix())) {
                    return ns;
                }
                ++i;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(prefix);
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return new StringBuffer(this.namespace.getPrefix()).append(':').append(this.name).toString();
    }

    public void addNamespaceDeclaration(Namespace additional) {
        String reason = Verifier.checkNamespaceCollision(additional, this);
        if (reason != null) {
            throw new IllegalAddException(this, additional, reason);
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(additional);
    }

    public Element addNamespaceDeclarationF(Namespace additional) {
        String reason = Verifier.checkNamespaceCollision(additional, this);
        if (reason != null) {
            throw new IllegalAddException(this, additional, reason);
        }
        ArrayList newadd = new ArrayList(5);
        int i = 0;
        while (i < this.additionalNamespaces.size()) {
            newadd.add(this.additionalNamespaces.get(i));
            ++i;
        }
        newadd.add(additional);
        Element elm = new Element(this.name, this.content, this.attributes, this.namespace, newadd);
        return elm;
    }

    public void removeNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(additionalNamespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public String getValue() {
        StringBuffer buffer = new StringBuffer();
        for (Content child : this.getContent()) {
            if (!(child instanceof Element) && !(child instanceof Text)) continue;
            buffer.append(child.getValue());
        }
        return buffer.toString();
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    public int getContentSize() {
        return this.content.size();
    }

    public int indexOf(Content child) {
        return this.content.indexOf(child);
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Object obj = this.content.get(0);
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuffer textContent = new StringBuffer();
        boolean hasText = false;
        int i = 0;
        while (i < this.content.size()) {
            Object obj = this.content.get(i);
            if (obj instanceof Text) {
                textContent.append(((Text)obj).getText());
                hasText = true;
            }
            ++i;
        }
        if (!hasText) {
            return "";
        }
        return textContent.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextNormalize(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getTextNormalize();
    }

    public String getChildText(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextNormalize(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getTextNormalize();
    }

    public Element setText(String text) {
        this.content.clear();
        if (text != null) {
            this.addContent(new Text(text));
        }
        return this;
    }

    public Element setTextF(String text) {
        ContentList cntList = new ContentList(this);
        cntList.add(0, new Text(text));
        Element elm = new Element(this.name, cntList, this.attributes, this.namespace, this.additionalNamespaces);
        return elm;
    }

    public ContentList getContent() {
        return this.content;
    }

    public List getContent(Filter filter) {
        return this.content.getView(filter);
    }

    public List removeContent() {
        ArrayList old = new ArrayList(this.content);
        this.content.clear();
        return old;
    }

    public List removeContent(Filter filter) {
        ArrayList<Content> old = new ArrayList<Content>();
        Iterator itr = this.content.getView(filter).iterator();
        while (itr.hasNext()) {
            Content child = (Content)itr.next();
            old.add(child);
            itr.remove();
        }
        return old;
    }

    public Element setContent(Collection newContent) {
        this.content.clearAndSet(newContent);
        return this;
    }

    public Element setContent(int index, Content child) {
        this.content.set(index, child);
        return this;
    }

    public Parent setContent(int index, Collection collection) {
        this.content.remove(index);
        this.content.addAll(index, collection);
        return this;
    }

    public Element addContent(String str) {
        return this.addContent(new Text(str));
    }

    public Element addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public Element addContent(Collection collection) {
        this.content.addAll(collection);
        return this;
    }

    public Element addContent(int index, Content child) {
        this.content.add(index, child);
        return this;
    }

    public Element addContentF(int index, Content child) {
        ContentList cntlist = this.content.addF(index, child);
        Element elm = new Element(this.name, cntlist, this.attributes, this.namespace, this.additionalNamespaces);
        return elm;
    }

    public Element addContent(int index, Collection c) {
        this.content.addAll(index, c);
        return this;
    }

    public List cloneContent() {
        int size = this.getContentSize();
        ArrayList<Object> list = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Content child = this.getContent(i);
            list.add(child.clone());
            ++i;
        }
        return list;
    }

    public Content getContent(int index) {
        return (Content)this.content.get(index);
    }

    public boolean removeContent(Content child) {
        return this.content.remove(child);
    }

    public Content removeContent(int index) {
        return (Content)this.content.remove(index);
    }

    public Element setContent(Content child) {
        this.content.clear();
        this.content.add(child);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent p = element.getParent();
        while (p instanceof Element) {
            if (p == this) {
                return true;
            }
            p = ((Element)p).getParent();
        }
        return false;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(name, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String name, Namespace ns) {
        return (Attribute)this.attributes.get(name, ns);
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String name, String def) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE, def);
    }

    public String getAttributeValue(String name, Namespace ns) {
        return this.getAttributeValue(name, ns, null);
    }

    public String getAttributeValue(String name, Namespace ns, String def) {
        Attribute attribute = (Attribute)this.attributes.get(name, ns);
        return attribute == null ? def : attribute.getValue();
    }

    public Element setAttributes(List newAttributes) {
        this.attributes.clearAndSet(newAttributes);
        return this;
    }

    public Element setAttributesF(List newAttributes) {
        AttributeList attList = new AttributeList(null);
        attList.clearAndSet(newAttributes);
        return new Element(this.name, this.content, attList, this.namespace, this.additionalNamespaces);
    }

    public Element setAttribute(String name, String value) {
        return this.setAttribute(new Attribute(name, value));
    }

    public Element setAttribute(String name, String value, Namespace ns) {
        return this.setAttribute(new Attribute(name, value, ns));
    }

    public Element setAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public Element setAttributeF(Attribute attribute) {
        AttributeList lst = this.attributes.addF(attribute);
        return new Element(this.name, this.content, lst, this.namespace, this.additionalNamespaces);
    }

    public Element setNameAttributeF(String nm, Attribute attribute) {
        AttributeList lst = this.attributes.addF(attribute);
        return new Element(nm, this.content, lst, this.namespace, this.additionalNamespaces);
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String name, Namespace ns) {
        return this.attributes.remove(name, ns);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public Element removeAttributeF(Attribute attribute) {
        AttributeList attList = this.attributes.removeF(attribute);
        Element elm = new Element(this.name, this.content, attList, this.namespace, this.additionalNamespaces);
        return elm;
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String nsuri = this.getNamespaceURI();
        if (!nsuri.equals("")) {
            stringForm.append(" [Namespace: ").append(nsuri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    public Object clone() {
        Object obj;
        int i;
        Element element = null;
        element = (Element)super.clone();
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        if (this.attributes != null) {
            i = 0;
            while (i < this.attributes.size()) {
                obj = this.attributes.get(i);
                Attribute attribute = (Attribute)((Attribute)obj).clone();
                element.attributes.add(attribute);
                ++i;
            }
        }
        if (this.additionalNamespaces != null) {
            int additionalSize = this.additionalNamespaces.size();
            element.additionalNamespaces = new ArrayList(additionalSize);
            int i2 = 0;
            while (i2 < additionalSize) {
                Object additional = this.additionalNamespaces.get(i2);
                element.additionalNamespaces.add(additional);
                ++i2;
            }
        }
        if (this.content != null) {
            i = 0;
            while (i < this.content.size()) {
                obj = this.content.get(i);
                if (obj instanceof Element) {
                    Element elt = (Element)((Element)obj).clone();
                    element.content.add(elt);
                } else if (obj instanceof CDATA) {
                    CDATA cdata = (CDATA)((CDATA)obj).clone();
                    element.content.add(cdata);
                } else if (obj instanceof Text) {
                    Text text = (Text)((Text)obj).clone();
                    element.content.add(text);
                } else if (obj instanceof Comment) {
                    Comment comment = (Comment)((Comment)obj).clone();
                    element.content.add(comment);
                } else if (obj instanceof ProcessingInstruction) {
                    ProcessingInstruction pi = (ProcessingInstruction)((ProcessingInstruction)obj).clone();
                    element.content.add(pi);
                } else if (obj instanceof EntityRef) {
                    EntityRef entity = (EntityRef)((EntityRef)obj).clone();
                    element.content.add(entity);
                }
                ++i;
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        element.setUpdatingStatus(this.flag);
        element.setID(this.id);
        return element;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.namespace.getPrefix());
        out.writeObject(this.namespace.getURI());
        if (this.additionalNamespaces == null) {
            out.write(0);
        } else {
            int size = this.additionalNamespaces.size();
            out.write(size);
            int i = 0;
            while (i < size) {
                Namespace additional = (Namespace)this.additionalNamespaces.get(i);
                out.writeObject(additional.getPrefix());
                out.writeObject(additional.getURI());
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)in.readObject(), (String)in.readObject());
        int size = in.read();
        if (size != 0) {
            this.additionalNamespaces = new ArrayList(size);
            int i = 0;
            while (i < size) {
                Namespace additional = Namespace.getNamespace((String)in.readObject(), (String)in.readObject());
                this.additionalNamespaces.add(additional);
                ++i;
            }
        }
    }

    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    public List getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public List getChildren(String name) {
        return this.content.getView(new ElementFilter(name));
    }

    public List getChildren(String name, Namespace ns) {
        return this.content.getView(new ElementFilter(name, ns));
    }

    public Element getChild(String name, Namespace ns) {
        List elements = this.content.getView(new ElementFilter(name, ns));
        Iterator i = elements.iterator();
        if (i.hasNext()) {
            return (Element)i.next();
        }
        return null;
    }

    public Element getChild(String name) {
        List elements = this.content.getView(new ElementFilter(name));
        Iterator i = elements.iterator();
        if (i.hasNext()) {
            return (Element)i.next();
        }
        return null;
    }

    public boolean removeChild(String name) {
        return this.removeChild(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String name, Namespace ns) {
        List old = this.content.getView(new ElementFilter(name, ns));
        Iterator i = old.iterator();
        if (i.hasNext()) {
            i.next();
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String name) {
        return this.removeChildren(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String name, Namespace ns) {
        boolean deletedSome = false;
        List old = this.content.getView(new ElementFilter(name, ns));
        Iterator i = old.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
            deletedSome = true;
        }
        return deletedSome;
    }

    public int getSubseqId() {
        return this.subseqid;
    }

    public Element setSubseqId(int id) {
        if (this.subseqid != -1) {
            Element elm = new Element(this.name, this.content, this.attributes, this.namespace, this.additionalNamespaces);
            elm.setSubseqId(id);
            elm.setID(this.getID());
            return elm;
        }
        this.subseqid = id;
        return this;
    }

    public List getAllSubsetID() {
        if (!this.firstSubseq) {
            return this.deepsubseqid;
        }
        this.firstSubseq = false;
        ArrayList lst = new ArrayList();
        this.collectAllSubseqID(lst);
        this.deepsubseqid = lst;
        return lst;
    }

    private void collectAllSubseqID(List setofssid) {
        if (this.subseqid != -1) {
            int i = 0;
            while (i < setofssid.size()) {
                Integer eid = (Integer)setofssid.get(i);
                if (eid == this.subseqid) {
                    return;
                }
                ++i;
            }
            setofssid.add(new Integer(this.subseqid));
            return;
        }
        int i = 0;
        while (i < this.content.size()) {
            Content cnt = (Content)this.content.get(i);
            if (cnt instanceof Element) {
                Element elm = (Element)cnt;
                elm.collectAllSubseqID(setofssid);
            }
            ++i;
        }
    }

    public void refreshUpdatinSum() {
        this.first = true;
        boolean sum = false;
    }

    public int getUpdatingSum() {
        if (!this.first) {
            return this.sum;
        }
        this.sum += this.flag;
        int i = 0;
        while (i < this.content.size()) {
            Content cnt = (Content)this.content.get(i);
            if (cnt instanceof Element) {
                Element elm = (Element)cnt;
                this.sum += elm.getUpdatingSum();
            } else if (cnt instanceof Text) {
                Text txt = (Text)cnt;
                this.sum += txt.getUpdatingStatus();
            }
            ++i;
        }
        i = 0;
        while (i < this.attributes.size()) {
            Attribute att = (Attribute)this.attributes.get(i);
            this.sum += att.getUpdatingStatus();
            ++i;
        }
        this.first = false;
        return this.sum;
    }
}

