/*
 * Decompiled with CFR 0.152.
 */
package org.jdomX;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdomX.Content;
import org.jdomX.DocType;
import org.jdomX.Element;
import org.jdomX.IllegalAddException;
import org.jdomX.Parent;
import org.jdomX.Text;
import org.jdomX.filter.Filter;

public final class ContentList
extends AbstractList
implements Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: ContentList.java,v $ $Revision: 1.1.1.1 $ $Date: 2007/06/26 01:25:08 $ $Name:  $";
    private static final int INITIAL_ARRAY_SIZE = 4;
    private static final int CREATE = 0;
    private static final int HASPREV = 1;
    private static final int HASNEXT = 2;
    private static final int PREV = 3;
    private static final int NEXT = 4;
    private static final int ADD = 5;
    private static final int REMOVE = 6;
    private Content[] elementData;
    private int size;
    private Parent parent;

    public ContentList(Parent parent) {
        this.parent = parent;
    }

    public Content[] getElementData() {
        return this.elementData;
    }

    final void uncheckedAddContent(Content c) {
        c.parent = this.parent;
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = c;
        ++this.modCount;
    }

    public void add(int index, Object obj) {
        if (obj == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (obj instanceof Content) {
            this.add(index, (Content)obj);
        } else if (obj instanceof String) {
            String str = (String)obj;
            this.add(index, new Text(str));
        } else {
            throw new IllegalAddException("Class " + obj.getClass().getName() + " is of unrecognized type and cannot be added");
        }
    }

    public ContentList addF(int index, Object obj) {
        if (obj == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (obj instanceof Content) {
            return this.addF(index, (Content)obj);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.addF(index, new Text(str));
        }
        throw new IllegalAddException("Class " + obj.getClass().getName() + " is of unrecognized type and cannot be added");
    }

    public void add(int index, Content child) {
        if (child == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        child.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (index == this.size) {
            this.elementData[this.size++] = child;
        } else {
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
            this.elementData[index] = child;
            ++this.size;
        }
        ++this.modCount;
    }

    ContentList addF(int index, Content child) {
        if (child == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        ContentList newcont = new ContentList(this.parent);
        newcont.ensureCapacity(this.size + 1);
        if (index == this.size) {
            System.arraycopy(this.elementData, 0, newcont.elementData, 0, this.size);
            newcont.elementData[this.size] = child;
            newcont.size = this.size + 1;
        } else {
            System.arraycopy(this.elementData, 0, newcont.elementData, 0, index);
            System.arraycopy(this.elementData, index, newcont.elementData, index + 1, this.size - index);
            newcont.elementData[index] = child;
            newcont.size = this.size + 1;
        }
        newcont.modCount = this.modCount++;
        return newcont;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAll(int index, Collection collection) {
        block6: {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            if (collection == null || collection.size() == 0) {
                return false;
            }
            this.ensureCapacity(this.size() + collection.size());
            count = 0;
            try {
                for (E obj : collection) {
                    this.add(index + count, (Object)obj);
                    ++count;
                }
                break block6;
            }
            catch (RuntimeException exception) {
                i = 0;
                ** while (i < count)
            }
lbl-1000:
            // 1 sources

            {
                this.remove(index);
                ++i;
                continue;
            }
lbl20:
            // 1 sources

            throw exception;
        }
        return true;
    }

    public void clear() {
        if (this.elementData != null) {
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    void clearAndSet(Collection collection) {
        Content[] old = this.elementData;
        int oldSize = this.size;
        this.elementData = null;
        this.size = 0;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException exception) {
                this.elementData = old;
                this.size = oldSize;
                throw exception;
            }
        } else {
            this.ensureCapacity(4);
        }
        ++this.modCount;
    }

    void ensureCapacity(int minCapacity) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(minCapacity, 4)];
        } else {
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                Content[] oldData = this.elementData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new Content[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.size);
            }
        }
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        return this.elementData[index];
    }

    List getView(Filter filter) {
        return new FilterList(filter);
    }

    int indexOfFirstElement() {
        if (this.elementData != null) {
            int i = 0;
            while (i < this.size) {
                if (this.elementData[i] instanceof Element) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    int indexOfDocType() {
        if (this.elementData != null) {
            int i = 0;
            while (i < this.size) {
                if (this.elementData[i] instanceof DocType) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        Content old = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return old;
    }

    public Object set(int index, Object obj) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        Object old = this.remove(index);
        try {
            this.add(index, obj);
        }
        catch (RuntimeException exception) {
            this.add(index, old);
            throw exception;
        }
        return old;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return super.toString();
    }

    private int getModCount() {
        return this.modCount;
    }

    class FilterList
    extends AbstractList
    implements Serializable {
        Filter filter;
        int count = 0;
        int expected = -1;

        FilterList(Filter filter) {
            this.filter = filter;
        }

        public void add(int index, Object obj) {
            if (this.filter.matches(obj)) {
                int adjusted = this.getAdjustedIndex(index);
                ContentList.this.add(adjusted, obj);
                ++this.expected;
                ++this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + obj.getClass().getName() + " '" + obj + "' to be added to the list");
            }
        }

        public Object get(int index) {
            int adjusted = this.getAdjustedIndex(index);
            return ContentList.this.get(adjusted);
        }

        public Iterator iterator() {
            return new FilterListIterator(this.filter, 0);
        }

        public ListIterator listIterator() {
            return new FilterListIterator(this.filter, 0);
        }

        public ListIterator listIterator(int index) {
            return new FilterListIterator(this.filter, index);
        }

        public Object remove(int index) {
            int adjusted = this.getAdjustedIndex(index);
            Object old = ContentList.this.get(adjusted);
            if (this.filter.matches(old)) {
                old = ContentList.this.remove(adjusted);
                ++this.expected;
                --this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + old.getClass().getName() + " '" + old + "' (index " + index + ") to be removed");
            }
            return old;
        }

        public Object set(int index, Object obj) {
            Object old = null;
            if (this.filter.matches(obj)) {
                int adjusted = this.getAdjustedIndex(index);
                old = ContentList.this.get(adjusted);
                if (!this.filter.matches(old)) {
                    throw new IllegalAddException("Filter won't allow the " + old.getClass().getName() + " '" + old + "' (index " + index + ") to be removed");
                }
                old = ContentList.this.set(adjusted, obj);
                this.expected += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + index + " to be set to " + obj.getClass().getName());
            }
            return old;
        }

        public int size() {
            if (this.expected == ContentList.this.getModCount()) {
                return this.count;
            }
            this.count = 0;
            int i = 0;
            while (i < ContentList.this.size()) {
                Content obj = ContentList.this.elementData[i];
                if (this.filter.matches(obj)) {
                    ++this.count;
                }
                ++i;
            }
            this.expected = ContentList.this.getModCount();
            return this.count;
        }

        private final int getAdjustedIndex(int index) {
            int adjusted = 0;
            int i = 0;
            while (i < ContentList.this.size) {
                Content obj = ContentList.this.elementData[i];
                if (this.filter.matches(obj)) {
                    if (index == adjusted) {
                        return i;
                    }
                    ++adjusted;
                }
                ++i;
            }
            if (index == adjusted) {
                return ContentList.this.size;
            }
            return ContentList.this.size + 1;
        }
    }

    class FilterListIterator
    implements ListIterator {
        Filter filter;
        int lastOperation;
        int initialCursor;
        int cursor;
        int last;
        int expected;

        FilterListIterator(Filter filter, int start) {
            this.filter = filter;
            this.initialCursor = this.initializeCursor(start);
            this.last = -1;
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 0;
        }

        public boolean hasNext() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    break;
                }
                case 3: {
                    this.cursor = this.last;
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.moveForward(this.last + 1);
                    break;
                }
                case 6: {
                    this.cursor = this.moveForward(this.last);
                    break;
                }
                case 1: {
                    this.cursor = this.moveForward(this.cursor + 1);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 2;
            }
            return this.cursor < ContentList.this.size();
        }

        public Object next() {
            this.checkConcurrentModification();
            if (!this.hasNext()) {
                this.last = ContentList.this.size();
                throw new NoSuchElementException();
            }
            this.last = this.cursor;
            this.lastOperation = 4;
            return ContentList.this.get(this.last);
        }

        public boolean hasPrevious() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    int size = ContentList.this.size();
                    if (this.cursor < size) break;
                    this.cursor = this.moveBackward(size - 1);
                    break;
                }
                case 3: 
                case 6: {
                    this.cursor = this.moveBackward(this.last - 1);
                    break;
                }
                case 2: {
                    this.cursor = this.moveBackward(this.cursor - 1);
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.last;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 1;
            }
            return this.cursor >= 0;
        }

        public Object previous() {
            this.checkConcurrentModification();
            if (!this.hasPrevious()) {
                this.last = -1;
                throw new NoSuchElementException();
            }
            this.last = this.cursor;
            this.lastOperation = 3;
            return ContentList.this.get(this.last);
        }

        public int nextIndex() {
            this.checkConcurrentModification();
            this.hasNext();
            int count = 0;
            int i = 0;
            while (i < ContentList.this.size()) {
                if (this.filter.matches(ContentList.this.get(i))) {
                    if (i == this.cursor) {
                        return count;
                    }
                    ++count;
                }
                ++i;
            }
            this.expected = ContentList.this.getModCount();
            return count;
        }

        public int previousIndex() {
            this.checkConcurrentModification();
            if (this.hasPrevious()) {
                int count = 0;
                int i = 0;
                while (i < ContentList.this.size()) {
                    if (this.filter.matches(ContentList.this.get(i))) {
                        if (i == this.cursor) {
                            return count;
                        }
                        ++count;
                    }
                    ++i;
                }
            }
            return -1;
        }

        public void add(Object obj) {
            this.checkConcurrentModification();
            if (!this.filter.matches(obj)) {
                throw new IllegalAddException("Filter won't allow add of " + obj.getClass().getName());
            }
            this.last = this.cursor + 1;
            ContentList.this.add(this.last, obj);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 5;
        }

        public void remove() {
            this.checkConcurrentModification();
            if (this.last < 0 || this.lastOperation == 6) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.lastOperation == 5) {
                throw new IllegalStateException("cannot call remove() after add()");
            }
            Object old = ContentList.this.get(this.last);
            if (!this.filter.matches(old)) {
                throw new IllegalAddException("Filter won't allow " + old.getClass().getName() + " (index " + this.last + ") to be removed");
            }
            ContentList.this.remove(this.last);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 6;
        }

        public void set(Object obj) {
            this.checkConcurrentModification();
            if (this.lastOperation == 5 || this.lastOperation == 6) {
                throw new IllegalStateException("cannot call set() after add() or remove()");
            }
            if (this.last < 0) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.filter.matches(obj)) {
                Object old = ContentList.this.get(this.last);
                if (!this.filter.matches(old)) {
                    throw new IllegalAddException("Filter won't allow " + old.getClass().getName() + " (index " + this.last + ") to be removed");
                }
            } else {
                throw new IllegalAddException("Filter won't allow index " + this.last + " to be set to " + obj.getClass().getName());
            }
            ContentList.this.set(this.last, obj);
            this.expected = ContentList.this.getModCount();
        }

        private int initializeCursor(int start) {
            if (start < 0) {
                throw new IndexOutOfBoundsException("Index: " + start);
            }
            int count = 0;
            int i = 0;
            while (i < ContentList.this.size()) {
                Object obj = ContentList.this.get(i);
                if (this.filter.matches(obj)) {
                    if (start == count) {
                        return i;
                    }
                    ++count;
                }
                ++i;
            }
            if (start > count) {
                throw new IndexOutOfBoundsException("Index: " + start + " Size: " + count);
            }
            return ContentList.this.size();
        }

        private int moveForward(int start) {
            if (start < 0) {
                start = 0;
            }
            int i = start;
            while (i < ContentList.this.size()) {
                Object obj = ContentList.this.get(i);
                if (this.filter.matches(obj)) {
                    return i;
                }
                ++i;
            }
            return ContentList.this.size();
        }

        private int moveBackward(int start) {
            if (start >= ContentList.this.size()) {
                start = ContentList.this.size() - 1;
            }
            int i = start;
            while (i >= 0) {
                Object obj = ContentList.this.get(i);
                if (this.filter.matches(obj)) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        private void checkConcurrentModification() {
            if (this.expected != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

