/*
 * Decompiled with CFR 0.152.
 */
package bicq.support;

import bicq.java.MethodDeclarationWrapper;
import bicq.java.UpdatedNode;
import bicq.support.CodeParser;
import bicq.support.Init;
import bicq.support.UpdatingStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jdomX.Element;

public class Util {
    public static void throwException(String msg) {
        System.out.println("=====Error=====\n" + msg);
        throw new RuntimeException(msg);
    }

    public static String readFile(String filename) {
        File srcFile = new File(filename);
        if (srcFile == null) {
            Util.throwException("The file " + filename + " does not exist!");
        }
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            try {
                input = new BufferedReader(new FileReader(srcFile));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    public static void writeFile(String filename, String contents) {
        File tgtFile = new File(filename);
        if (tgtFile == null) {
            Util.throwException("The file " + filename + " does not exist!");
        }
        Writer output = null;
        try {
            try {
                output = new BufferedWriter(new FileWriter(tgtFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                output.write(contents);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void update(ASTNode src, ASTNode view) {
        if (src instanceof FieldDeclaration && view instanceof FieldDeclaration) {
            FieldDeclaration fsrc = (FieldDeclaration)src;
            FieldDeclaration fview = (FieldDeclaration)view;
            Type newtype = (Type)Util.clone(src.getAST(), (ASTNode)fview.getType());
            fsrc.setType(newtype);
            List srcfragList = fsrc.fragments();
            List viewfragList = fview.fragments();
            if (srcfragList.size() != viewfragList.size()) {
                Util.throwException("Some field declarations are removed!");
            }
            int i = 0;
            while (i < srcfragList.size()) {
                VariableDeclarationFragment srcfrag = (VariableDeclarationFragment)srcfragList.get(i);
                VariableDeclarationFragment viewfrag = (VariableDeclarationFragment)viewfragList.get(i);
                Util.update((ASTNode)srcfrag, (ASTNode)viewfrag);
                ++i;
            }
        }
        if (src instanceof VariableDeclarationFragment && view instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment srcfrag = (VariableDeclarationFragment)src;
            VariableDeclarationFragment viewfrag = (VariableDeclarationFragment)view;
            Expression initexpr = (Expression)Util.clone(src.getAST(), (ASTNode)viewfrag.getInitializer());
            srcfrag.setInitializer(initexpr);
        }
    }

    public static List split1(List V, List lens) {
        ArrayList ValSeq = new ArrayList();
        int num = lens.size();
        int pos = 0;
        int i = 0;
        while (i < num) {
            Integer subsen = (Integer)lens.get(i);
            int slen = subsen;
            List subseq = V.subList(pos, pos + slen);
            ValSeq.add(subseq);
            pos += slen;
            ++i;
        }
        return ValSeq;
    }

    public static List buildUpdatedView(List view, Element update) {
        if (update.getName().equals("none")) {
            return view;
        }
        ArrayList<UpdatedNode> newview = new ArrayList<UpdatedNode>(view.size());
        int i = 0;
        while (i < view.size()) {
            ASTNode node = (ASTNode)view.get(i);
            if (node instanceof MethodInvocation) {
                UpdatedNode newnode = Util.updateMethodInvocationNode((MethodInvocation)node, update);
                newview.add(newnode);
            } else {
                Util.throwException("Updating a node with unsupported type");
            }
            ++i;
        }
        return newview;
    }

    public static UpdatedNode updateMethodInvocationNode(MethodInvocation node, Element update) {
        int nodeid = node.getStartPosition();
        String amname = "call_" + node.getName().toString() + "_" + Integer.toString(nodeid);
        AST ast = node.getAST();
        SimpleName name = ast.newSimpleName(amname);
        SimpleName callname = node.getName();
        MethodInvocation revisednode = ast.newMethodInvocation();
        revisednode.setName(name);
        Expression receiver = null;
        if (node.getExpression() != null) {
            receiver = node.getExpression();
            if (Util.isType(receiver.toString())) {
                revisednode.arguments().add(ast.newNullLiteral());
            } else {
                revisednode.arguments().add(Util.clone(ast, (ASTNode)node.getExpression()));
            }
        } else {
            revisednode.arguments().add(ast.newNullLiteral());
        }
        revisednode.arguments().addAll(ASTNode.copySubtrees((AST)ast, (List)node.arguments()));
        revisednode.setProperty(UpdatingStatus.NAME, (Object)UpdatingStatus.REVISEDCALL);
        ArrayList<MethodDeclarationWrapper> auxi_methods = new ArrayList<MethodDeclarationWrapper>();
        ArrayList<MethodDeclarationWrapper> auxi_methods_potencial = new ArrayList<MethodDeclarationWrapper>();
        ArrayList<MethodDeclaration> sigmethods = null;
        if (receiver == null) {
            sigmethods = Util.searchMethodDecs(node.getName().toString());
        } else if (!Util.isType(receiver.toString())) {
            sigmethods = Util.searchMethodDecs(node.getName().toString());
        } else {
            sigmethods = Util.searchMethodDecs(node.getName().toString(), receiver.toString());
            ArrayList<MethodDeclaration> temp = new ArrayList<MethodDeclaration>();
            int i = 0;
            while (i < sigmethods.size()) {
                MethodDeclaration tempmd = (MethodDeclaration)sigmethods.get(i);
                if (Util.isStatic(tempmd)) {
                    temp.add(tempmd);
                }
                ++i;
            }
            sigmethods = temp;
        }
        int i = 0;
        while (i < sigmethods.size()) {
            Statement wrappedstm;
            MethodDeclaration refmethod = (MethodDeclaration)sigmethods.get(i);
            TypeDeclaration parentclass = (TypeDeclaration)refmethod.getParent();
            SimpleName refclassname = (SimpleName)Util.clone(ast, (ASTNode)parentclass.getName());
            MethodDeclarationWrapper mdr = new MethodDeclarationWrapper(ast);
            if (receiver == null) {
                Modifier mdi;
                List modifiers = refmethod.modifiers();
                if (modifiers.size() > 0 && (mdi = (Modifier)modifiers.get(i)).isStatic()) {
                    Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.STATIC_KEYWORD;
                    mdr.modifiers.add(ast.newModifier(keyword));
                }
            } else {
                Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.STATIC_KEYWORD;
                mdr.modifiers.add(ast.newModifier(keyword));
            }
            mdr.methodname = (SimpleName)Util.clone(ast, (ASTNode)name);
            mdr.returntype = (Type)Util.clone(ast, (ASTNode)refmethod.getReturnType2());
            SimpleName revname = ast.newSimpleName("rev");
            SingleVariableDeclaration rev = ast.newSingleVariableDeclaration();
            rev.setType((Type)ast.newSimpleType((Name)refclassname));
            rev.setName(revname);
            mdr.parameters.add(rev);
            int j = 0;
            while (j < refmethod.parameters().size()) {
                ASTNode onearg = Util.clone(ast, (ASTNode)refmethod.parameters().get(j));
                mdr.parameters.add(onearg);
                ++j;
            }
            String advice = update.getChildText("code");
            Block adviceblock = new CodeParser(advice).parseBodyStm();
            List adviceargs = update.getChild("args").getChildren();
            if (!Util.matchAdviceMethod(adviceargs, refmethod.parameters())) {
                if (receiver == null) {
                    wrappedstm = Util.wrapMethodInvocation1(ast, callname, refmethod);
                    mdr.instrumentedcode = wrappedstm;
                    auxi_methods_potencial.add(mdr);
                } else if (!Util.isType(receiver.toString())) {
                    wrappedstm = Util.wrapMethodInvocation0(ast, (Expression)revname, callname, refmethod);
                    mdr.instrumentedcode = wrappedstm;
                    auxi_methods.add(mdr);
                } else {
                    wrappedstm = Util.wrapMethodInvocation0(ast, receiver, callname, refmethod);
                    mdr.instrumentedcode = wrappedstm;
                    auxi_methods.add(mdr);
                }
            } else {
                int j2 = 0;
                while (j2 < refmethod.parameters().size()) {
                    SingleVariableDeclaration formalarg = (SingleVariableDeclaration)refmethod.parameters().get(j2);
                    Element advicearg = (Element)adviceargs.get(j2);
                    SimpleName advicevar = ast.newSimpleName(advicearg.getChildText("var"));
                    if (!formalarg.getName().toString().equals(advicearg.getChildText("var"))) {
                        VariableDeclarationFragment vardec = ast.newVariableDeclarationFragment();
                        vardec.setName(advicevar);
                        vardec.setInitializer((Expression)Util.clone(ast, (ASTNode)formalarg.getName()));
                        VariableDeclarationStatement newvardecstm = ast.newVariableDeclarationStatement(vardec);
                        newvardecstm.setType((Type)Util.clone(ast, (ASTNode)formalarg.getType()));
                        mdr.connection.add(newvardecstm);
                    }
                    ++j2;
                }
                mdr.advicecodes.add((Block)Util.clone(ast, adviceblock));
                if (update.getChildText("pos").equals("before")) {
                    mdr.position = "before";
                } else if (update.getChildText("pos").equals("after")) {
                    mdr.position = "after";
                } else if (update.getChildText("pos").equals("around")) {
                    mdr.position = "around";
                } else {
                    Util.throwException("The postion arg " + update.getChildText("pos") + " is unknown");
                }
                if (receiver == null) {
                    wrappedstm = Util.wrapMethodInvocation1(ast, callname, refmethod);
                    mdr.instrumentedcode = wrappedstm;
                    auxi_methods_potencial.add(mdr);
                } else if (!Util.isType(receiver.toString())) {
                    wrappedstm = Util.wrapMethodInvocation0(ast, (Expression)revname, callname, refmethod);
                    mdr.instrumentedcode = wrappedstm;
                    auxi_methods.add(mdr);
                } else {
                    wrappedstm = Util.wrapMethodInvocation0(ast, receiver, callname, refmethod);
                    mdr.instrumentedcode = wrappedstm;
                    auxi_methods.add(mdr);
                }
            }
            ++i;
        }
        UpdatedNode viewnode = new UpdatedNode((ASTNode)revisednode, auxi_methods, auxi_methods_potencial);
        return viewnode;
    }

    public static List searchMethodDecs(String methodname) {
        ArrayList<MethodDeclaration> ValSeq = new ArrayList<MethodDeclaration>();
        List classes = Init.sourcecode.types();
        int i = 0;
        while (i < classes.size()) {
            TypeDeclaration classdec = (TypeDeclaration)classes.get(i);
            if (!classdec.isInterface()) {
                MethodDeclaration[] methods = classdec.getMethods();
                int j = 0;
                while (j < methods.length) {
                    SimpleName mname = methods[j].getName();
                    if (mname.toString().equals(methodname)) {
                        ValSeq.add(methods[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ValSeq;
    }

    public static List searchMethodDecs(String methodname, String typename) {
        ArrayList<MethodDeclaration> ValSeq = new ArrayList<MethodDeclaration>();
        List classes = Init.sourcecode.types();
        int i = 0;
        while (i < classes.size()) {
            String classname;
            TypeDeclaration classdec = (TypeDeclaration)classes.get(i);
            if (!classdec.isInterface() && Util.isSubType(classname = classdec.getName().toString(), typename)) {
                MethodDeclaration[] methods = classdec.getMethods();
                int j = 0;
                while (j < methods.length) {
                    SimpleName mname = methods[j].getName();
                    if (mname.toString().equals(methodname)) {
                        ValSeq.add(methods[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ValSeq;
    }

    static boolean matchAdviceMethod(List adviceargs, List refmethodargs) {
        if (adviceargs.size() != refmethodargs.size()) {
            return false;
        }
        int i = 0;
        while (i < adviceargs.size()) {
            SingleVariableDeclaration vardec;
            String vardectype;
            Element advicearg = (Element)adviceargs.get(i);
            String adviceargtypename = advicearg.getChildText("type");
            if (!adviceargtypename.equals(vardectype = (vardec = (SingleVariableDeclaration)refmethodargs.get(i)).getType().toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isType(String name) {
        List classes = Init.sourcecode.types();
        int i = 0;
        while (i < classes.size()) {
            TypeDeclaration classdec = (TypeDeclaration)classes.get(i);
            if (classdec.getName().toString().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isStatic(MethodDeclaration mddec) {
        List modifiers = mddec.modifiers();
        int i = 0;
        while (i < modifiers.size()) {
            Modifier md = (Modifier)modifiers.get(i);
            if (md.isStatic()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSubType(String subtypename, String typename) {
        if (subtypename.equals(typename)) {
            return true;
        }
        if (typename.equals("Objects")) {
            return true;
        }
        List classes = Init.sourcecode.types();
        int i = 0;
        if (i < classes.size()) {
            TypeDeclaration classdec = (TypeDeclaration)classes.get(i);
            Type parenttype = classdec.getSuperclassType();
            if (parenttype == null) {
                return false;
            }
            if (parenttype.toString().equals("Object")) {
                return false;
            }
            return Util.isSubType(parenttype.toString(), typename);
        }
        return false;
    }

    private static Statement wrapMethodInvocation0(AST ast, Expression revname, SimpleName callname, MethodDeclaration refmethod) {
        MethodInvocation wrappedcall = ast.newMethodInvocation();
        wrappedcall.setExpression((Expression)Util.clone(ast, (ASTNode)revname));
        wrappedcall.setName((SimpleName)Util.clone(ast, (ASTNode)callname));
        int j = 0;
        while (j < refmethod.parameters().size()) {
            SingleVariableDeclaration formalarg = (SingleVariableDeclaration)refmethod.parameters().get(j);
            wrappedcall.arguments().add(Util.clone(ast, (ASTNode)formalarg.getName()));
            ++j;
        }
        Type returntype = refmethod.getReturnType2();
        ReturnStatement callstm = null;
        if (returntype instanceof PrimitiveType) {
            PrimitiveType preturntype = (PrimitiveType)returntype;
            if (preturntype.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                callstm = ast.newExpressionStatement((Expression)wrappedcall);
            } else {
                ReturnStatement rstm = ast.newReturnStatement();
                rstm.setExpression((Expression)wrappedcall);
                callstm = rstm;
            }
        } else {
            ReturnStatement rstm = ast.newReturnStatement();
            rstm.setExpression((Expression)wrappedcall);
            callstm = rstm;
        }
        return callstm;
    }

    private static Statement wrapMethodInvocation1(AST ast, SimpleName callname, MethodDeclaration refmethod) {
        MethodInvocation wrappedcall = ast.newMethodInvocation();
        wrappedcall.setName((SimpleName)Util.clone(ast, (ASTNode)callname));
        int j = 0;
        while (j < refmethod.parameters().size()) {
            SingleVariableDeclaration formalarg = (SingleVariableDeclaration)refmethod.parameters().get(j);
            wrappedcall.arguments().add(Util.clone(ast, (ASTNode)formalarg.getName()));
            ++j;
        }
        Type returntype = refmethod.getReturnType2();
        ReturnStatement callstm = null;
        if (returntype instanceof PrimitiveType) {
            PrimitiveType preturntype = (PrimitiveType)returntype;
            if (preturntype.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                callstm = ast.newExpressionStatement((Expression)wrappedcall);
            } else {
                ReturnStatement rstm = ast.newReturnStatement();
                rstm.setExpression((Expression)wrappedcall);
                callstm = rstm;
            }
        } else {
            ReturnStatement rstm = ast.newReturnStatement();
            rstm.setExpression((Expression)wrappedcall);
            callstm = rstm;
        }
        return callstm;
    }

    public static List merge(List V1, List V2) {
        ArrayList<UpdatedNode> ValSeq = new ArrayList<UpdatedNode>();
        if (V1.size() != V2.size()) {
            Util.throwException("Fail to merge two views with different size");
        }
        int i = 0;
        while (i < V1.size()) {
            UpdatedNode newupnode;
            ArrayList new_auxiliary_methods_potential;
            ArrayList new_auxiliary_methods;
            ASTNode newblock;
            ASTNode block2;
            ASTNode block1;
            MethodDeclarationWrapper wrp;
            MethodDeclarationWrapper lazywrp;
            List auxiliary_methods_original;
            ASTNode newnode;
            ASTNode node2;
            ASTNode node1;
            Object obj1 = V1.get(i);
            Object obj2 = V2.get(i);
            if (obj1 instanceof UpdatedNode && obj2 instanceof UpdatedNode) {
                node1 = ((UpdatedNode)obj1).getNode();
                node2 = ((UpdatedNode)obj2).getNode();
                newnode = Util.mergeNode(node1, node2);
                List auxiliary_methods_original1 = ((UpdatedNode)obj1).getMethodDec();
                List auxiliary_methods_original2 = ((UpdatedNode)obj2).getMethodDec();
                if (newnode.getProperty(MethodBodyToMerge.NAME) != null) {
                    ASTNode newblock2;
                    ASTNode block22;
                    ASTNode block12;
                    MethodDeclarationWrapper wrp2;
                    MethodDeclarationWrapper lazywrp2 = (MethodDeclarationWrapper)newnode.getProperty(MethodBodyToMerge.NAME);
                    boolean first = false;
                    int j = 0;
                    while (j < auxiliary_methods_original1.size()) {
                        wrp2 = (MethodDeclarationWrapper)auxiliary_methods_original1.get(j);
                        if (wrp2.eq(lazywrp2)) {
                            block12 = wrp2.instrumentedcode;
                            block22 = lazywrp2.instrumentedcode;
                            wrp2.instrumentedcode = newblock2 = Util.mergeNode(block12, block22);
                            first = true;
                            break;
                        }
                        ++j;
                    }
                    if (!first) {
                        j = 0;
                        while (j < auxiliary_methods_original2.size()) {
                            wrp2 = (MethodDeclarationWrapper)auxiliary_methods_original2.get(j);
                            if (wrp2.eq(lazywrp2)) {
                                block12 = wrp2.instrumentedcode;
                                block22 = lazywrp2.instrumentedcode;
                                wrp2.instrumentedcode = newblock2 = Util.mergeNode(block12, block22);
                                first = true;
                                break;
                            }
                            ++j;
                        }
                    }
                }
                ArrayList new_auxiliary_methods2 = new ArrayList(auxiliary_methods_original1.size() + auxiliary_methods_original2.size());
                new_auxiliary_methods2.addAll(auxiliary_methods_original1);
                new_auxiliary_methods2.addAll(auxiliary_methods_original2);
                ArrayList new_auxiliary_methods_potential2 = new ArrayList(((UpdatedNode)obj1).getMethodDec1().size() + ((UpdatedNode)obj2).getMethodDec1().size());
                new_auxiliary_methods_potential2.addAll(((UpdatedNode)obj1).getMethodDec1());
                new_auxiliary_methods_potential2.addAll(((UpdatedNode)obj2).getMethodDec1());
                UpdatedNode newupnode2 = new UpdatedNode(newnode, new_auxiliary_methods2, new_auxiliary_methods_potential2);
                ValSeq.add(newupnode2);
            } else if (obj1 instanceof UpdatedNode && obj2 instanceof ASTNode) {
                node1 = ((UpdatedNode)obj1).getNode();
                node2 = (ASTNode)obj2;
                newnode = Util.mergeNode(node1, node2);
                auxiliary_methods_original = ((UpdatedNode)obj1).getMethodDec();
                if (newnode.getProperty(MethodBodyToMerge.NAME) != null) {
                    lazywrp = (MethodDeclarationWrapper)newnode.getProperty(MethodBodyToMerge.NAME);
                    int j = 0;
                    while (j < auxiliary_methods_original.size()) {
                        wrp = (MethodDeclarationWrapper)auxiliary_methods_original.get(j);
                        if (wrp.eq(lazywrp)) {
                            block1 = wrp.instrumentedcode;
                            block2 = lazywrp.instrumentedcode;
                            wrp.instrumentedcode = newblock = Util.mergeNode(block1, block2);
                            break;
                        }
                        ++j;
                    }
                }
                new_auxiliary_methods = new ArrayList(((UpdatedNode)obj1).getMethodDec().size());
                new_auxiliary_methods.addAll(auxiliary_methods_original);
                new_auxiliary_methods_potential = new ArrayList(((UpdatedNode)obj1).getMethodDec1().size());
                new_auxiliary_methods_potential.addAll(((UpdatedNode)obj1).getMethodDec1());
                newupnode = new UpdatedNode(newnode, new_auxiliary_methods, new_auxiliary_methods_potential);
                ValSeq.add(newupnode);
            } else if (obj1 instanceof ASTNode && obj2 instanceof UpdatedNode) {
                node1 = (ASTNode)obj1;
                node2 = ((UpdatedNode)obj2).getNode();
                newnode = Util.mergeNode(node1, node2);
                auxiliary_methods_original = ((UpdatedNode)obj2).getMethodDec();
                if (newnode.getProperty(MethodBodyToMerge.NAME) != null) {
                    lazywrp = (MethodDeclarationWrapper)newnode.getProperty(MethodBodyToMerge.NAME);
                    int j = 0;
                    while (j < auxiliary_methods_original.size()) {
                        wrp = (MethodDeclarationWrapper)auxiliary_methods_original.get(j);
                        if (wrp.eq(lazywrp)) {
                            block1 = wrp.instrumentedcode;
                            block2 = lazywrp.instrumentedcode;
                            wrp.instrumentedcode = newblock = Util.mergeNode(block1, block2);
                            break;
                        }
                        ++j;
                    }
                }
                new_auxiliary_methods = new ArrayList(((UpdatedNode)obj2).getMethodDec().size());
                new_auxiliary_methods.addAll(auxiliary_methods_original);
                new_auxiliary_methods_potential = new ArrayList(((UpdatedNode)obj2).getMethodDec1().size());
                new_auxiliary_methods_potential.addAll(((UpdatedNode)obj2).getMethodDec1());
                newupnode = new UpdatedNode(newnode, new_auxiliary_methods, new_auxiliary_methods_potential);
                ValSeq.add(newupnode);
            } else {
                node1 = (ASTNode)obj1;
                node2 = (ASTNode)obj2;
                newnode = Util.mergeNode(node1, node2);
                ValSeq.add((UpdatedNode)newnode);
            }
            ++i;
        }
        return ValSeq;
    }

    private static ASTNode mergeNode(NumberLiteral n1, NumberLiteral n2) {
        AST ast = n1.getAST();
        Object updatingObj1 = n1.getProperty(UpdatingStatus.NAME);
        Object updatingObj2 = n2.getProperty(UpdatingStatus.NAME);
        if (updatingObj1 == null && updatingObj2 == null) {
            if (!n1.getToken().equals(n2.getToken())) {
                Util.throwException("Modification on an integer without annotation");
            }
        } else {
            Util.throwException("SimpleName is changed");
        }
        NumberLiteral newnum = ast.newNumberLiteral(n1.getToken());
        return newnum;
    }

    private static ASTNode mergeNode(SimpleName n1, SimpleName n2) {
        AST ast = n1.getAST();
        SimpleName nm1 = n1;
        SimpleName nm2 = n2;
        Object updatingObj1 = nm1.getProperty(UpdatingStatus.NAME);
        Object updatingObj2 = nm2.getProperty(UpdatingStatus.NAME);
        if (updatingObj1 == null && updatingObj2 == null) {
            if (!nm1.getIdentifier().equals(nm2.getIdentifier())) {
                Util.throwException("Modification on a simple name without annotation");
            }
        } else {
            Util.throwException("SimpleName is changed");
        }
        SimpleName newname = ast.newSimpleName(nm1.getIdentifier());
        return newname;
    }

    private static ASTNode mergeNode(SimpleType n1, SimpleType n2) {
        AST ast = n1.getAST();
        Object updatingObj1 = n1.getProperty(UpdatingStatus.NAME);
        Object updatingObj2 = n2.getProperty(UpdatingStatus.NAME);
        if (updatingObj1 == null && updatingObj2 == null) {
            if (!n1.getName().toString().equals(n2.getName().toString())) {
                Util.throwException("Modification on a simple name without annotation");
            }
        } else {
            Util.throwException("SimpleType is changed");
        }
        SimpleType newty = ast.newSimpleType((Name)((SimpleName)Util.clone(ast, (ASTNode)n1.getName())));
        return newty;
    }

    private static ASTNode mergeNode(MethodInvocation n1, MethodInvocation n2) {
        AST ast = n1.getAST();
        MethodInvocation newcall = ast.newMethodInvocation();
        MethodInvocation call1 = n1;
        MethodInvocation call2 = n2;
        Object updatingObj1 = call1.getProperty(UpdatingStatus.NAME);
        Object updatingObj2 = call2.getProperty(UpdatingStatus.NAME);
        if (updatingObj1 == null && updatingObj2 == null) {
            Expression receiver1 = call1.getExpression();
            Expression receiver2 = call2.getExpression();
            Expression newreceiver = (Expression)Util.mergeNode((ASTNode)receiver1, (ASTNode)receiver2);
            newcall.setExpression(newreceiver);
            newcall.setName((SimpleName)Util.mergeNode(call1.getName(), call2.getName()));
            List args1 = call1.arguments();
            List args2 = call2.arguments();
            List newargs = newcall.arguments();
            if (args1.size() != args2.size()) {
                Util.throwException("Fail to merge too method calls");
            }
            int i = 0;
            while (i < args1.size()) {
                Expression argi1 = (Expression)args1.get(i);
                Expression argi2 = (Expression)args2.get(i);
                Expression newargi = (Expression)Util.mergeNode((ASTNode)argi1, (ASTNode)argi2);
                newargs.add(newargi);
                ++i;
            }
        } else if (updatingObj1 != null && updatingObj2 == null) {
            String updating1 = (String)updatingObj1;
            if (!updating1.equals(UpdatingStatus.REVISEDCALL)) {
                Util.throwException("Illegal revised call");
            }
            newcall.setProperty(UpdatingStatus.NAME, (Object)UpdatingStatus.REVISEDCALL);
            newcall.setName((SimpleName)Util.clone(ast, (ASTNode)call1.getName()));
            List args1 = call1.arguments();
            List args2 = call2.arguments();
            Expression receiver1 = (Expression)args1.get(0);
            Expression receiver2 = call2.getExpression();
            Expression newreceiver = (Expression)Util.mergeNode((ASTNode)receiver1, (ASTNode)receiver2);
            List newargs = newcall.arguments();
            newargs.add(newreceiver);
            if (args1.size() != args2.size() + 1) {
                Util.throwException("Fail to merge two method calls with different arguments");
            }
            int i = 0;
            while (i < args2.size()) {
                Expression argiplus1 = (Expression)args1.get(i + 1);
                Expression argi = (Expression)args2.get(i);
                Expression newargi = (Expression)Util.mergeNode((ASTNode)argiplus1, (ASTNode)argi);
                newargs.add(newargi);
                ++i;
            }
        } else if (updatingObj1 == null && updatingObj2 != null) {
            String updating2 = (String)updatingObj2;
            if (!updating2.equals(UpdatingStatus.REVISEDCALL)) {
                Util.throwException("Illegal revised call");
            }
            newcall.setProperty(UpdatingStatus.NAME, (Object)UpdatingStatus.REVISEDCALL);
            newcall.setName((SimpleName)Util.clone(ast, (ASTNode)call2.getName()));
            List args1 = call1.arguments();
            List args2 = call2.arguments();
            Expression receiver1 = call1.getExpression();
            Expression receiver2 = (Expression)args2.get(0);
            Expression newreceiver = (Expression)Util.mergeNode((ASTNode)receiver1, (ASTNode)receiver2);
            List newargs = newcall.arguments();
            newargs.add(newreceiver);
            if (args1.size() + 1 != args2.size()) {
                Util.throwException("Fail to merge two method calls with different arguments");
            }
            int i = 0;
            while (i < args1.size()) {
                Expression argiplus1 = (Expression)args2.get(i + 1);
                Expression argi = (Expression)args1.get(i);
                Expression newargi = (Expression)Util.mergeNode((ASTNode)argiplus1, (ASTNode)argi);
                newargs.add(newargi);
                ++i;
            }
        } else {
            String updating2 = (String)updatingObj2;
            String updating1 = (String)updatingObj1;
            if (!updating1.equals(UpdatingStatus.REVISEDCALL) && !updating2.equals(UpdatingStatus.REVISEDCALL)) {
                Util.throwException("Illegal revised call");
            }
            SimpleName newname = (SimpleName)Util.mergeNode(call1.getName(), call2.getName());
            newcall.setProperty(UpdatingStatus.NAME, (Object)UpdatingStatus.REVISEDCALL);
            newcall.setName(newname);
            List args1 = call1.arguments();
            List args2 = call2.arguments();
            List newargs = newcall.arguments();
            if (args1.size() != args2.size()) {
                Util.throwException("Fail to merge two method calls with different arguments");
            }
            int i = 0;
            while (i < args1.size()) {
                Expression argi1 = (Expression)args1.get(i);
                Expression argi2 = (Expression)args2.get(i);
                Expression newargi = (Expression)Util.mergeNode((ASTNode)argi1, (ASTNode)argi2);
                newargs.add(newargi);
                ++i;
            }
        }
        return newcall;
    }

    private static ASTNode mergeNode(InfixExpression n1, InfixExpression n2) {
        AST ast = n1.getAST();
        InfixExpression newinfix = ast.newInfixExpression();
        if (!n1.getOperator().toString().equals(n2.getOperator().toString())) {
            Util.throwException("Fail to merge two infix expressions with different operators");
        }
        if (n1.extendedOperands().size() != n2.extendedOperands().size()) {
            Util.throwException("Fail to merge two infix expressions with different extended operands");
        }
        newinfix.setOperator(n1.getOperator());
        Expression left1 = n1.getLeftOperand();
        Expression left2 = n2.getLeftOperand();
        Expression newleft = (Expression)Util.mergeNode((ASTNode)left1, (ASTNode)left2);
        newinfix.setLeftOperand(newleft);
        Expression right1 = n1.getRightOperand();
        Expression right2 = n2.getRightOperand();
        Expression newright = (Expression)Util.mergeNode((ASTNode)right1, (ASTNode)right2);
        newinfix.setRightOperand(newright);
        int i = 0;
        while (i < n1.extendedOperands().size()) {
            Expression e1 = (Expression)n1.extendedOperands().get(i);
            Expression e2 = (Expression)n2.extendedOperands().get(i);
            Expression newextend = (Expression)Util.mergeNode((ASTNode)e1, (ASTNode)e2);
            newinfix.extendedOperands().add(newextend);
            ++i;
        }
        return newinfix;
    }

    private static ASTNode mergeNode(MethodDeclaration n1, MethodDeclaration n2) {
        String updating;
        ASTNode stm;
        AST ast = n1.getAST();
        if (!n1.getName().toString().equals(n2.getName().toString())) {
            Util.throwException("Fail to merge two methods with different name");
        }
        if (!n1.getReturnType2().toString().equals(n2.getReturnType2().toString())) {
            Util.throwException("Fail to merge two methods with different return type");
        }
        if (n1.parameters().size() != n2.parameters().size()) {
            Util.throwException("Fail to merge two methods with different numbers of parameters");
        }
        if (n1.modifiers().size() != n2.modifiers().size()) {
            Util.throwException("Fail to merge two methods with different numbers of modifiers");
        }
        int i = 0;
        while (i < n1.modifiers().size()) {
            Modifier mdf1 = (Modifier)n1.modifiers().get(i);
            Modifier mdf2 = (Modifier)n2.modifiers().get(i);
            if (!mdf1.toString().equals(mdf2.toString())) {
                Util.throwException("Fail to merge two methods with different modifiers");
            }
            ++i;
        }
        i = 0;
        while (i < n1.parameters().size()) {
            SingleVariableDeclaration par1 = (SingleVariableDeclaration)n1.parameters().get(i);
            SingleVariableDeclaration par2 = (SingleVariableDeclaration)n2.parameters().get(i);
            if (!par1.getType().toString().equals(par2.getType().toString())) {
                Util.throwException("Fail to merge two methods with parameter type");
            }
            if (!par1.getName().toString().equals(par2.getName().toString())) {
                Util.throwException("Fail to merge two methods with parameter name");
            }
            ++i;
        }
        MethodDeclaration newdec = ast.newMethodDeclaration();
        newdec.setBody(ast.newBlock());
        newdec.setName((SimpleName)Util.clone(ast, (ASTNode)n1.getName()));
        newdec.setReturnType2((Type)Util.clone(ast, (ASTNode)n1.getReturnType2()));
        int i2 = 0;
        while (i2 < n1.modifiers().size()) {
            Modifier mdf = (Modifier)n1.modifiers().get(i2);
            newdec.modifiers().add(Util.clone(ast, (ASTNode)mdf));
            ++i2;
        }
        i2 = 0;
        while (i2 < n1.parameters().size()) {
            SingleVariableDeclaration par = (SingleVariableDeclaration)n1.parameters().get(i2);
            newdec.parameters().add(Util.clone(ast, (ASTNode)par));
            ++i2;
        }
        ArrayList<ASTNode> prenewsts = new ArrayList<ASTNode>();
        List stsList1 = n1.getBody().statements();
        List stsList2 = n2.getBody().statements();
        int pos1 = 0;
        int pos2 = 0;
        int i3 = 0;
        while (i3 < stsList1.size()) {
            stm = (ASTNode)stsList1.get(i3);
            updating = (String)stm.getProperty(UpdatingStatus.NAME);
            if (updating == null || !updating.equals(UpdatingStatus.STATETRAN)) break;
            prenewsts.add(Util.clone(ast, stm));
            ++pos1;
            ++i3;
        }
        i3 = 0;
        while (i3 < stsList2.size()) {
            stm = (ASTNode)stsList2.get(i3);
            updating = (String)stm.getProperty(UpdatingStatus.NAME);
            if (updating == null || !updating.equals(UpdatingStatus.STATETRAN)) break;
            prenewsts.add(Util.clone(ast, stm));
            ++pos2;
            ++i3;
        }
        ASTNode stm1 = (ASTNode)stsList1.get(pos1);
        ASTNode stm2 = (ASTNode)stsList2.get(pos2);
        String updating1 = (String)stm1.getProperty(UpdatingStatus.NAME);
        String updating2 = (String)stm2.getProperty(UpdatingStatus.NAME);
        if (updating1 == null && updating2 == null) {
            if (stsList1.size() - pos1 != stsList2.size() - pos2) {
                Util.throwException("Fail to merge two method with different length of body");
            }
            int i4 = 0;
            while (i4 < stsList1.size() - pos1) {
                ASTNode stmi1 = (ASTNode)stsList1.get(pos1 + i4);
                ASTNode stmi2 = (ASTNode)stsList2.get(pos2 + i4);
                ASTNode newstmi = Util.mergeNode(stmi1, stmi2);
                prenewsts.add(newstmi);
                ++i4;
            }
            newdec.getBody().statements().addAll(prenewsts);
        } else if (updating1 != null && updating2 != null) {
            ASTNode stmi;
            if (!updating1.equals(UpdatingStatus.REVISEDMETHODBODY) || !updating2.equals(UpdatingStatus.REVISEDMETHODBODY)) {
                Util.throwException("Revised method body is expected");
            }
            ASTNode wrappedbody = (ASTNode)stsList1.get(pos1);
            prenewsts.add(Util.clone(ast, wrappedbody));
            int i5 = 1;
            while (i5 < stsList1.size() - pos1) {
                stmi = (ASTNode)stsList1.get(pos1 + i5);
                prenewsts.add(Util.clone(ast, stmi));
                ++i5;
            }
            i5 = 1;
            while (i5 < stsList2.size() - pos2) {
                stmi = (ASTNode)stsList2.get(pos2 + i5);
                prenewsts.add(Util.clone(ast, stmi));
                ++i5;
            }
            newdec.getBody().statements().addAll(prenewsts);
        } else if (updating1 != null && updating2 == null) {
            int i6 = 0;
            while (i6 < stsList1.size() - pos1) {
                ASTNode stmi1 = (ASTNode)stsList1.get(pos1 + i6);
                prenewsts.add(Util.clone(ast, stmi1));
                ++i6;
            }
            Block newblk = ast.newBlock();
            newblk.statements().addAll(prenewsts);
            newdec.setBody(newblk);
            MethodDeclarationWrapper wrappermd = new MethodDeclarationWrapper(ast);
            wrappermd.methodname = ast.newSimpleName(String.valueOf(n2.getName().toString()) + "_body");
            wrappermd.returntype = (Type)Util.clone(ast, (ASTNode)n2.getReturnType2());
            int i7 = 0;
            while (i7 < n2.modifiers().size()) {
                Modifier mdf = (Modifier)n2.modifiers().get(i7);
                wrappermd.modifiers.add(Util.clone(ast, (ASTNode)mdf));
                ++i7;
            }
            i7 = 0;
            while (i7 < n2.parameters().size()) {
                SingleVariableDeclaration par = (SingleVariableDeclaration)n2.parameters().get(i7);
                wrappermd.parameters.add(Util.clone(ast, (ASTNode)par));
                ++i7;
            }
            wrappermd.instrumentedcode = Util.clone(ast, n2.getBody());
            newdec.setProperty(MethodBodyToMerge.NAME, (Object)wrappermd);
        } else {
            int i8 = 0;
            while (i8 < stsList2.size() - pos2) {
                ASTNode stmi2 = (ASTNode)stsList1.get(pos2 + i8);
                prenewsts.add(Util.clone(ast, stmi2));
                ++i8;
            }
            newdec.getBody().statements().addAll(prenewsts);
            MethodDeclarationWrapper wrappermd = new MethodDeclarationWrapper(ast);
            wrappermd.methodname = ast.newSimpleName(String.valueOf(n1.getName().toString()) + "_body");
            wrappermd.returntype = (Type)Util.clone(ast, (ASTNode)n1.getReturnType2());
            int i9 = 0;
            while (i9 < n1.modifiers().size()) {
                Modifier mdf = (Modifier)n1.modifiers().get(i9);
                wrappermd.modifiers.add(Util.clone(ast, (ASTNode)mdf));
                ++i9;
            }
            i9 = 0;
            while (i9 < n1.parameters().size()) {
                SingleVariableDeclaration par = (SingleVariableDeclaration)n1.parameters().get(i9);
                wrappermd.parameters.add(Util.clone(ast, (ASTNode)par));
                ++i9;
            }
            wrappermd.instrumentedcode = Util.clone(ast, n1.getBody());
            newdec.setProperty(MethodBodyToMerge.NAME, (Object)wrappermd);
        }
        return newdec;
    }

    private static ASTNode mergeNode(Block n1, Block n2) {
        AST ast = n1.getAST();
        Block newblk = ast.newBlock();
        List sts = newblk.statements();
        List sts1 = n1.statements();
        List sts2 = n2.statements();
        if (sts1.size() != sts2.size()) {
            Util.throwException("Fail to merge two blocks with different length");
        }
        int i = 0;
        while (i < sts1.size()) {
            Statement stm1 = (Statement)sts1.get(i);
            Statement stm2 = (Statement)sts2.get(i);
            Statement newstm = (Statement)Util.mergeNode((ASTNode)stm1, (ASTNode)stm2);
            sts.add(newstm);
            ++i;
        }
        return newblk;
    }

    private static ASTNode mergeNode(VariableDeclarationStatement n1, VariableDeclarationStatement n2) {
        if (!n1.getType().toString().equals(n2.getType().toString())) {
            Util.throwException("Fail to merge two variable declaration statements with different types");
        }
        AST ast = n1.getAST();
        List frags1 = n1.fragments();
        List frags2 = n2.fragments();
        if (frags1.size() != frags2.size()) {
            Util.throwException("Fail to merge two variable fragments with different length");
        }
        ArrayList<VariableDeclarationFragment> frags = new ArrayList<VariableDeclarationFragment>();
        int i = 0;
        while (i < frags1.size()) {
            VariableDeclarationFragment frag1 = (VariableDeclarationFragment)frags1.get(i);
            VariableDeclarationFragment frag2 = (VariableDeclarationFragment)frags2.get(i);
            VariableDeclarationFragment newfrag = (VariableDeclarationFragment)Util.mergeNode(frag1, frag2);
            frags.add(newfrag);
            ++i;
        }
        VariableDeclarationStatement newvardec = ast.newVariableDeclarationStatement((VariableDeclarationFragment)frags.get(0));
        newvardec.fragments().clear();
        newvardec.fragments().addAll(frags);
        newvardec.setType((Type)Util.clone(ast, (ASTNode)n1.getType()));
        return newvardec;
    }

    private static ASTNode mergeNode(VariableDeclarationFragment n1, VariableDeclarationFragment n2) {
        AST ast = n1.getAST();
        if (!n1.getName().toString().equals(n2.getName().toString())) {
            Util.throwException("Fail to merge variable declarations with different names");
        }
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName((SimpleName)Util.clone(ast, (ASTNode)n1.getName()));
        Expression newexpr = (Expression)Util.mergeNode((ASTNode)n1.getInitializer(), (ASTNode)n2.getInitializer());
        frag.setInitializer(newexpr);
        return frag;
    }

    private static ASTNode mergeNode(ClassInstanceCreation n1, ClassInstanceCreation n2) {
        int i;
        AST ast = n1.getAST();
        ClassInstanceCreation newclass = ast.newClassInstanceCreation();
        Expression newexpr = (Expression)Util.mergeNode((ASTNode)n1.getExpression(), (ASTNode)n2.getExpression());
        newclass.setExpression(newexpr);
        if (n1.getAST().apiLevel() >= 3 && n2.getAST().apiLevel() >= 3) {
            if (n1.typeArguments().size() != n2.typeArguments().size()) {
                Util.throwException("Fail to merge class instance creations with different length of type arguments");
            }
            i = 0;
            while (i < n1.typeArguments().size()) {
                newclass.typeArguments().add(Util.mergeNode((ASTNode)n1.typeArguments().get(i), (ASTNode)n2.typeArguments().get(i)));
                ++i;
            }
            newclass.setType((Type)Util.mergeNode((ASTNode)n1.getType(), (ASTNode)n2.getType()));
        }
        if (n1.arguments().size() != n2.arguments().size()) {
            Util.throwException("Fail to merge class instance creations with different length of arguments");
        }
        i = 0;
        while (i < n1.arguments().size()) {
            newclass.arguments().add(Util.mergeNode((ASTNode)n1.arguments().get(i), (ASTNode)n2.arguments().get(i)));
            ++i;
        }
        newclass.setAnonymousClassDeclaration((AnonymousClassDeclaration)Util.mergeNode((ASTNode)n1.getAnonymousClassDeclaration(), (ASTNode)n2.getAnonymousClassDeclaration()));
        return newclass;
    }

    private static ASTNode mergeNode(PostfixExpression n1, PostfixExpression n2) {
        AST ast = n1.getAST();
        PostfixExpression newpostfix = ast.newPostfixExpression();
        if (!n1.getOperator().toString().equals(n2.getOperator().toString())) {
            Util.throwException("Fail to merge two postfix expressions with different operators");
        }
        newpostfix.setOperator(n1.getOperator());
        Expression op1 = n1.getOperand();
        Expression op2 = n2.getOperand();
        Expression newleft = (Expression)Util.mergeNode((ASTNode)op1, (ASTNode)op2);
        newpostfix.setOperand(newleft);
        return newpostfix;
    }

    private static ASTNode mergeNode(ReturnStatement n1, ReturnStatement n2) {
        AST ast = n1.getAST();
        ReturnStatement newretstm = ast.newReturnStatement();
        Expression r1 = n1.getExpression();
        Expression r2 = n2.getExpression();
        Expression newr = (Expression)Util.mergeNode((ASTNode)r1, (ASTNode)r2);
        newretstm.setExpression(newr);
        return newretstm;
    }

    private static ASTNode mergeNode(ExpressionStatement n1, ExpressionStatement n2) {
        AST ast = n1.getAST();
        Expression r1 = n1.getExpression();
        Expression r2 = n2.getExpression();
        Expression newr = (Expression)Util.mergeNode((ASTNode)r1, (ASTNode)r2);
        ExpressionStatement newexprstm = ast.newExpressionStatement(newr);
        return newexprstm;
    }

    private static ASTNode mergeNode(IfStatement n1, IfStatement n2) {
        AST ast = n1.getAST();
        IfStatement newifstm = ast.newIfStatement();
        Expression cond1 = n1.getExpression();
        Expression cond2 = n2.getExpression();
        Expression newcond = (Expression)Util.mergeNode((ASTNode)cond1, (ASTNode)cond2);
        newifstm.setExpression(newcond);
        Statement then1 = n1.getThenStatement();
        Statement then2 = n2.getThenStatement();
        Statement newthen = (Statement)Util.mergeNode((ASTNode)then1, (ASTNode)then2);
        newifstm.setThenStatement(newthen);
        Statement else1 = n1.getElseStatement();
        Statement else2 = n2.getElseStatement();
        Statement newelse = (Statement)Util.mergeNode((ASTNode)else1, (ASTNode)else2);
        newifstm.setElseStatement(newelse);
        return newifstm;
    }

    private static ASTNode mergeNode(ASTNode n1, ASTNode n2) {
        if (n1 == null || n2 == null) {
            if (n1 == null && n2 == null) {
                return null;
            }
            if (n1 instanceof NullLiteral) {
                return n1.getAST().newNullLiteral();
            }
            if (n2 instanceof NullLiteral) {
                return n2.getAST().newNullLiteral();
            }
            return null;
        }
        if (n1.getNodeType() != n2.getNodeType()) {
            Util.throwException("Fail to merge two nodes with different types");
        }
        ASTNode newnode = null;
        if (n1.getNodeType() == 32) {
            newnode = Util.mergeNode((MethodInvocation)n1, (MethodInvocation)n2);
        } else if (n1.getNodeType() == 42) {
            newnode = Util.mergeNode((SimpleName)n1, (SimpleName)n2);
        } else if (n1.getNodeType() == 43) {
            newnode = Util.mergeNode((SimpleType)n1, (SimpleType)n2);
        } else if (n1.getNodeType() == 34) {
            newnode = Util.mergeNode((NumberLiteral)n1, (NumberLiteral)n2);
        } else if (n1.getNodeType() == 27) {
            newnode = Util.mergeNode((InfixExpression)n1, (InfixExpression)n2);
        } else if (n1.getNodeType() == 31) {
            newnode = Util.mergeNode((MethodDeclaration)n1, (MethodDeclaration)n2);
        } else if (n1.getNodeType() == 8) {
            newnode = Util.mergeNode((Block)n1, (Block)n2);
        } else if (n1.getNodeType() == 60) {
            newnode = Util.mergeNode((VariableDeclarationStatement)n1, (VariableDeclarationStatement)n2);
        } else if (n1.getNodeType() == 59) {
            newnode = Util.mergeNode((VariableDeclarationFragment)n1, (VariableDeclarationFragment)n2);
        } else if (n1.getNodeType() == 14) {
            newnode = Util.mergeNode((ClassInstanceCreation)n1, (ClassInstanceCreation)n2);
        } else if (n1.getNodeType() == 37) {
            newnode = Util.mergeNode((PostfixExpression)n1, (PostfixExpression)n2);
        } else if (n1.getNodeType() == 41) {
            newnode = Util.mergeNode((ReturnStatement)n1, (ReturnStatement)n2);
        } else if (n1.getNodeType() == 21) {
            newnode = Util.mergeNode((ExpressionStatement)n1, (ExpressionStatement)n2);
        } else if (n1.getNodeType() == 25) {
            newnode = Util.mergeNode((IfStatement)n1, (IfStatement)n2);
        } else {
            Util.throwException("To do: mergeNode");
        }
        return newnode;
    }

    public static ASTNode clone(AST ast, InfixExpression node) {
        InfixExpression result = ast.newInfixExpression();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setOperator(node.getOperator());
        result.setLeftOperand((Expression)Util.clone(ast, (ASTNode)node.getLeftOperand()));
        result.setRightOperand((Expression)Util.clone(ast, (ASTNode)node.getRightOperand()));
        int i = 0;
        while (i < node.extendedOperands().size()) {
            result.extendedOperands().add(Util.clone(ast, (ASTNode)node.extendedOperands().get(i)));
            ++i;
        }
        return result;
    }

    public static ASTNode clone(AST ast, MethodInvocation node) {
        int i;
        MethodInvocation result = ast.newMethodInvocation();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setName((SimpleName)Util.clone(ast, (ASTNode)node.getName()));
        result.setExpression((Expression)Util.clone(ast, (ASTNode)node.getExpression()));
        if (node.getAST().apiLevel() >= 3) {
            i = 0;
            while (i < node.typeArguments().size()) {
                result.typeArguments().add(Util.clone(ast, (ASTNode)node.typeArguments().get(i)));
                ++i;
            }
        }
        i = 0;
        while (i < node.arguments().size()) {
            result.arguments().add(Util.clone(ast, (ASTNode)node.arguments().get(i)));
            ++i;
        }
        result.setProperty(UpdatingStatus.NAME, node.getProperty(UpdatingStatus.NAME));
        return result;
    }

    public static ASTNode clone(AST ast, MethodDeclaration node) {
        int i;
        MethodDeclaration result = ast.newMethodDeclaration();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setJavadoc((Javadoc)Util.clone(ast, (ASTNode)node.getJavadoc()));
        if (node.getAST().apiLevel() >= 3) {
            i = 0;
            while (i < node.modifiers().size()) {
                result.modifiers().add(Util.clone(ast, (ASTNode)node.modifiers().get(i)));
                ++i;
            }
            i = 0;
            while (i < node.typeParameters().size()) {
                result.typeParameters().add(Util.clone(ast, (ASTNode)node.typeParameters().get(i)));
                ++i;
            }
            result.setReturnType2((Type)Util.clone(ast, (ASTNode)node.getReturnType2()));
        }
        result.setConstructor(node.isConstructor());
        result.setExtraDimensions(node.getExtraDimensions());
        result.setName((SimpleName)Util.clone(ast, (ASTNode)node.getName()));
        i = 0;
        while (i < node.parameters().size()) {
            result.parameters().add(Util.clone(ast, (ASTNode)node.parameters().get(i)));
            ++i;
        }
        i = 0;
        while (i < node.thrownExceptions().size()) {
            result.thrownExceptions().add(Util.clone(ast, (ASTNode)node.thrownExceptions().get(i)));
            ++i;
        }
        result.setBody((Block)Util.clone(ast, node.getBody()));
        return result;
    }

    public static ASTNode clone(AST ast, VariableDeclarationStatement node) {
        int i;
        VariableDeclarationStatement result = ast.newVariableDeclarationStatement((VariableDeclarationFragment)Util.clone(ast, (ASTNode)node.fragments().get(0)));
        result.setSourceRange(node.getStartPosition(), node.getLength());
        if (node.getAST().apiLevel() == 2) {
            result.setModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            i = 0;
            while (i < node.modifiers().size()) {
                result.modifiers().add(Util.clone(ast, (ASTNode)node.modifiers().get(i)));
                ++i;
            }
        }
        result.setType((Type)Util.clone(ast, (ASTNode)node.getType()));
        i = 1;
        while (i < node.fragments().size()) {
            result.fragments().add(Util.clone(ast, (ASTNode)node.fragments().get(i)));
            ++i;
        }
        return result;
    }

    public static ASTNode clone(AST ast, VariableDeclarationFragment node) {
        VariableDeclarationFragment result = ast.newVariableDeclarationFragment();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setName((SimpleName)Util.clone(ast, (ASTNode)node.getName()));
        result.setExtraDimensions(node.getExtraDimensions());
        result.setInitializer((Expression)Util.clone(ast, (ASTNode)node.getInitializer()));
        return result;
    }

    public static ASTNode clone(AST ast, Assignment node) {
        Assignment result = ast.newAssignment();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setOperator(node.getOperator());
        result.setLeftHandSide((Expression)Util.clone(ast, (ASTNode)node.getLeftHandSide()));
        result.setRightHandSide((Expression)Util.clone(ast, (ASTNode)node.getRightHandSide()));
        result.setProperty(UpdatingStatus.NAME, node.getProperty(UpdatingStatus.NAME));
        return result;
    }

    public static ASTNode clone(AST ast, ExpressionStatement node) {
        Expression expr = node.getExpression();
        ASTNode copyexpr = Util.clone(ast, (ASTNode)expr);
        ExpressionStatement result = ast.newExpressionStatement((Expression)copyexpr);
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setProperty(UpdatingStatus.NAME, node.getProperty(UpdatingStatus.NAME));
        return result;
    }

    public static ASTNode clone(AST ast, Block node) {
        Block result = ast.newBlock();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        int i = 0;
        while (i < node.statements().size()) {
            result.statements().add(Util.clone(ast, (ASTNode)node.statements().get(i)));
            ++i;
        }
        return result;
    }

    public static ASTNode clone(AST ast, ClassInstanceCreation node) {
        int i;
        ClassInstanceCreation result = ast.newClassInstanceCreation();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setExpression((Expression)Util.clone(ast, (ASTNode)node.getExpression()));
        if (node.getAST().apiLevel() >= 3) {
            i = 0;
            while (i < node.typeArguments().size()) {
                result.typeArguments().add(Util.clone(ast, (ASTNode)node.typeArguments().get(i)));
                ++i;
            }
            result.setType((Type)Util.clone(ast, (ASTNode)node.getType()));
        }
        i = 0;
        while (i < node.arguments().size()) {
            result.arguments().add(Util.clone(ast, (ASTNode)node.arguments().get(i)));
            ++i;
        }
        result.setAnonymousClassDeclaration((AnonymousClassDeclaration)Util.clone(ast, (ASTNode)node.getAnonymousClassDeclaration()));
        return result;
    }

    public static ASTNode clone(AST ast, PostfixExpression node) {
        PostfixExpression result = ast.newPostfixExpression();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setOperator(node.getOperator());
        result.setOperand((Expression)Util.clone(ast, (ASTNode)node.getOperand()));
        return result;
    }

    public static ASTNode clone(AST ast, ReturnStatement node) {
        ReturnStatement result = ast.newReturnStatement();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setExpression((Expression)Util.clone(ast, (ASTNode)node.getExpression()));
        return result;
    }

    public static ASTNode clone(AST ast, IfStatement node) {
        IfStatement result = ast.newIfStatement();
        result.setSourceRange(node.getStartPosition(), node.getLength());
        result.setExpression((Expression)Util.clone(ast, (ASTNode)node.getExpression()));
        result.setThenStatement((Statement)Util.clone(ast, (ASTNode)node.getThenStatement()));
        result.setElseStatement((Statement)Util.clone(ast, (ASTNode)node.getElseStatement()));
        return result;
    }

    public static ASTNode clone(AST ast, ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode newnode = node.getNodeType() == 27 ? Util.clone(ast, (InfixExpression)node) : (node.getNodeType() == 32 ? Util.clone(ast, (MethodInvocation)node) : (node.getNodeType() == 31 ? Util.clone(ast, (MethodDeclaration)node) : (node.getNodeType() == 60 ? Util.clone(ast, (VariableDeclarationStatement)node) : (node.getNodeType() == 59 ? Util.clone(ast, (VariableDeclarationFragment)node) : (node.getNodeType() == 7 ? Util.clone(ast, (Assignment)node) : (node.getNodeType() == 21 ? Util.clone(ast, (ExpressionStatement)node) : (node.getNodeType() == 8 ? Util.clone(ast, (Block)node) : (node.getNodeType() == 14 ? Util.clone(ast, (ClassInstanceCreation)node) : (node.getNodeType() == 37 ? Util.clone(ast, (PostfixExpression)node) : (node.getNodeType() == 41 ? Util.clone(ast, (ReturnStatement)node) : (node.getNodeType() == 25 ? Util.clone(ast, (IfStatement)node) : ASTNode.copySubtree((AST)ast, (ASTNode)node))))))))))));
        return newnode;
    }

    static class MethodBodyToMerge {
        static String NAME = "methodbodytomerge";

        MethodBodyToMerge() {
        }
    }
}

