/*
 * Decompiled with CFR 0.152.
 */
package bicq.support;

import bicq.generic.XAction;
import bicq.generic.XConst;
import bicq.generic.XEq;
import bicq.generic.XFree;
import bicq.generic.XFunApp;
import bicq.generic.XID;
import bicq.generic.XIf;
import bicq.generic.XLet;
import bicq.generic.XLoad;
import bicq.generic.XMap;
import bicq.generic.XPar;
import bicq.generic.XSeq;
import bicq.generic.XStore;
import bicq.generic.XSubseq;
import bicq.java.XArguments;
import bicq.java.XBody;
import bicq.java.XChgStVar;
import bicq.java.XClass;
import bicq.java.XClassName;
import bicq.java.XDecStVar;
import bicq.java.XExtendExprs;
import bicq.java.XField;
import bicq.java.XFormalArgs;
import bicq.java.XIsStatic;
import bicq.java.XLeftExpr;
import bicq.java.XMakeAsm;
import bicq.java.XMethod;
import bicq.java.XMethodName;
import bicq.java.XNodeTypeTest;
import bicq.java.XRetExpr;
import bicq.java.XRightExpr;
import bicq.java.XStmExpr;
import bicq.java.XVarDecFrag;
import bicq.java.XVarDecInit;
import bicq.java.XVarDecName;
import bicq.java.XVarDecType;
import bicq.support.Init;
import bicq.support.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdomX.Attribute;
import org.jdomX.ContentList;
import org.jdomX.Document;
import org.jdomX.Element;
import org.jdomX.EntityRef;
import org.jdomX.JDOMException;
import org.jdomX.ProcessingInstruction;
import org.jdomX.Text;
import org.jdomX.input.SAXBuilder;

public class CodeElement
extends Element {
    private static final long serialVersionUID = 1L;

    public CodeElement(String tag) {
        super(tag);
    }

    public static void importlibrary(Document doc) {
        ContentList content = doc.getContent();
        for (Object obj : content) {
            if (obj instanceof ProcessingInstruction) {
                String libraryname;
                ProcessingInstruction pi = (ProcessingInstruction)obj;
                String piname = pi.getTarget();
                if (!piname.equals("import") || (libraryname = pi.getPseudoAttributeValue("library")) == null) continue;
                CodeElement.buildSymbolTable(libraryname);
                continue;
            }
            if (obj instanceof Element) break;
        }
    }

    private static void buildSymbolTable(String LibName) {
        SAXBuilder codebuilder = new SAXBuilder();
        Document codedoc = null;
        try {
            codedoc = codebuilder.build(LibName);
        }
        catch (JDOMException e) {
            System.out.println("\n not well-formed.");
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e);
        }
        Element elm1 = codedoc.getRootElement();
        String rootname = elm1.getName();
        if (!rootname.equals("library")) {
            Util.throwException("Library Must be defined with the library root element");
        }
        List functions = elm1.getChildren();
        int len = functions.size();
        int i = 0;
        while (i < len) {
            Element elm;
            Element body;
            Attribute att;
            List atts;
            int arglen;
            Element fundec = (Element)functions.get(i);
            if (!fundec.getName().equals("function")) {
                Util.throwException("Function Must be defined with the function element");
            }
            if ((arglen = (atts = fundec.getAttributes()).size()) == 0) {
                Util.throwException("Function must have a name.");
            }
            if (!(att = (Attribute)atts.get(0)).getName().equals("name")) {
                Util.throwException("Function must have a name attribue for its name.");
            }
            String funname = att.getValue();
            ArrayList<String> argnamelist = new ArrayList<String>();
            int j = 1;
            while (j < arglen) {
                Attribute attarg = (Attribute)atts.get(j);
                argnamelist.add(attarg.getValue());
                ++j;
            }
            List prebody = fundec.getChildren();
            int bodylen = prebody.size();
            if (bodylen == 0) {
                body = new Element("xconst");
            } else if (bodylen > 1) {
                elm = new Element("xseq");
                List prebody1 = prebody;
                elm.setContent(prebody1);
                body = elm;
            } else {
                body = elm = (Element)prebody.get(0);
            }
            Init.symboltable.add(funname, argnamelist, body);
            ++i;
        }
    }

    public static CodeElement cast(Element elm) {
        String tag = elm.getName();
        ContentList content = elm.getContent();
        List attlist = elm.getAttributes();
        CodeElement elmcode = new CodeElement(tag);
        ContentList codecontent = elmcode.getContent();
        List codeattlist = elmcode.getAttributes();
        if (tag.equals("xconst")) {
            codecontent.addAll(content);
            return elmcode;
        }
        for (Attribute att : attlist) {
            codeattlist.add(att.clone());
        }
        for (Object cnt : content) {
            if (cnt instanceof Element) {
                codecontent.add(CodeElement.cast((Element)cnt));
                continue;
            }
            if (cnt instanceof Text) {
                Text txt = (Text)cnt;
                codecontent.add(txt.clone());
                continue;
            }
            if (cnt instanceof Attribute) {
                Attribute attr = (Attribute)cnt;
                codecontent.add(attr.clone());
                continue;
            }
            if (cnt instanceof ProcessingInstruction) {
                ProcessingInstruction intr = (ProcessingInstruction)cnt;
                codecontent.add(intr.clone());
                continue;
            }
            if (cnt instanceof EntityRef) {
                EntityRef ent = (EntityRef)cnt;
                codecontent.add(ent.clone());
                continue;
            }
            codecontent.add(cnt);
        }
        return elmcode;
    }

    public XAction makeAction() {
        XAction action = this.dispatcher(this);
        return action;
    }

    private XAction dispatcher(CodeElement elm) {
        XAction action = null;
        if (elm.getName() == "xid") {
            action = new XID(elm);
        }
        if (elm.getName() == "xseq") {
            action = new XSeq(elm);
        }
        if (elm.getName() == "xconst") {
            action = new XConst(elm);
        }
        if (elm.getName() == "xhide") {
            action = new XConst(new CodeElement("xconst"));
        }
        if (elm.getName() == "xmap") {
            action = new XMap(elm);
        }
        if (elm.getName() == "xif") {
            action = new XIf(elm);
        }
        if (elm.getName() == "xeq") {
            action = new XEq(elm);
        }
        if (elm.getName() == "xload") {
            action = new XLoad(elm);
        }
        if (elm.getName() == "xvar") {
            action = new XLoad(elm);
        }
        if (elm.getName() == "xstore") {
            action = new XStore(elm);
        }
        if (elm.getName() == "xfree") {
            action = new XFree(elm);
        }
        if (elm.getName() == "xlet") {
            action = new XLet(elm);
        }
        if (elm.getName() == "xfunapp") {
            action = new XFunApp(elm);
        }
        if (elm.getName() == "xsubseq") {
            action = new XSubseq(elm);
        }
        if (elm.getName() == "xpar") {
            action = new XPar(elm);
        }
        if (elm.getName() == "xfield") {
            action = new XField(elm);
        }
        if (elm.getName() == "xmethod") {
            action = new XMethod(elm);
        }
        if (elm.getName() == "xclass") {
            action = new XClass(elm);
        }
        if (elm.getName() == "xclassname") {
            action = new XClassName(elm);
        }
        if (elm.getName() == "xisstatic") {
            action = new XIsStatic(elm);
        }
        if (elm.getName() == "xmethodname") {
            action = new XMethodName(elm);
        }
        if (elm.getName() == "xformalargs") {
            action = new XFormalArgs(elm);
        }
        if (elm.getName() == "xbody") {
            action = new XBody(elm);
        }
        if (elm.getName() == "xvardectype") {
            action = new XVarDecType(elm);
        }
        if (elm.getName() == "xvardecfrag") {
            action = new XVarDecFrag(elm);
        }
        if (elm.getName() == "xvardecname") {
            action = new XVarDecName(elm);
        }
        if (elm.getName() == "xvardecinit") {
            action = new XVarDecInit(elm);
        }
        if (elm.getName() == "xnodetypetest") {
            action = new XNodeTypeTest(elm);
        }
        if (elm.getName() == "xisnode") {
            action = new XNodeTypeTest(elm);
        }
        if (elm.getName() == "xdecstvar") {
            action = new XDecStVar(elm);
        }
        if (elm.getName() == "xchgstvar") {
            action = new XChgStVar(elm);
        }
        if (elm.getName() == "xmkasm" || elm.getName() == "xmakeasm") {
            action = new XMakeAsm(elm);
        }
        if (elm.getName() == "xarguments") {
            action = new XArguments(elm);
        }
        if (elm.getName() == "xleftexpr") {
            action = new XLeftExpr(elm);
        }
        if (elm.getName() == "xrightexpr") {
            action = new XRightExpr(elm);
        }
        if (elm.getName() == "xextendexprs") {
            action = new XExtendExprs(elm);
        }
        if (elm.getName() == "xstmexpr") {
            action = new XStmExpr(elm);
        }
        if (elm.getName() == "xretexpr") {
            action = new XRetExpr(elm);
        }
        if (action == null) {
            Util.throwException("A wrong xcode tag: " + elm.getName());
        }
        return action;
    }
}

