/*
 * Decompiled with CFR 0.152.
 */
package bicq.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;

public class MethodDeclarationWrapper {
    public AST ast;
    public Type returntype;
    public SimpleName methodname;
    public List parameters = new ArrayList();
    public ASTNode instrumentedcode;
    public List advicecodes = new ArrayList();
    public List conditions = new ArrayList();
    public String position = "none";
    public List connection = new ArrayList();
    public List modifiers = new ArrayList();

    public MethodDeclarationWrapper(AST a) {
        this.ast = a;
    }

    public MethodDeclaration buildMethodDec() {
        MethodDeclaration md = this.ast.newMethodDeclaration();
        md.modifiers().addAll(this.modifiers);
        md.setConstructor(false);
        md.setName(this.methodname);
        md.setReturnType2(this.returntype);
        md.parameters().addAll(this.parameters);
        Block newblock = this.ast.newBlock();
        if (this.advicecodes.size() == 0) {
            if (this.instrumentedcode instanceof Block) {
                md.setBody((Block)this.instrumentedcode);
            } else {
                newblock.statements().add(this.instrumentedcode);
                md.setBody(newblock);
            }
            return md;
        }
        Expression condexpr = null;
        if (this.conditions.size() == 1) {
            condexpr = (Expression)this.conditions.get(0);
        } else if (this.conditions.size() > 1) {
            InfixExpression tempcond = this.ast.newInfixExpression();
            tempcond.setOperator(InfixExpression.Operator.AND);
            tempcond.setLeftOperand((Expression)this.conditions.get(1));
            tempcond.setRightOperand((Expression)this.conditions.get(0));
            int i = 2;
            while (i < this.conditions.size()) {
                InfixExpression tempcond1 = this.ast.newInfixExpression();
                tempcond1.setOperator(InfixExpression.Operator.AND);
                tempcond1.setRightOperand((Expression)tempcond);
                tempcond1.setLeftOperand((Expression)this.conditions.get(i));
                tempcond = tempcond1;
                ++i;
            }
            condexpr = tempcond;
        }
        if (this.position.equals("before")) {
            if (condexpr == null) {
                newblock.statements().addAll(this.connection);
                newblock.statements().addAll(this.advicecodes);
            } else {
                IfStatement ifstm = this.ast.newIfStatement();
                ifstm.setExpression(condexpr);
                Block thenblock = this.ast.newBlock();
                thenblock.statements().addAll(this.connection);
                thenblock.statements().addAll(this.advicecodes);
                ifstm.setThenStatement((Statement)thenblock);
                newblock.statements().add(ifstm);
            }
            newblock.statements().add(this.instrumentedcode);
        }
        if (this.position.equals("after")) {
            newblock.statements().add(this.instrumentedcode);
            newblock.statements().addAll(this.connection);
            newblock.statements().addAll(this.advicecodes);
        }
        md.setBody(newblock);
        return md;
    }

    public boolean eq(MethodDeclarationWrapper wrp) {
        if (!this.methodname.toString().equals(wrp.methodname.toString())) {
            return false;
        }
        if (!this.returntype.toString().equals(wrp.returntype.toString())) {
            return false;
        }
        if (this.parameters.size() != wrp.parameters.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            SingleVariableDeclaration vardec1 = (SingleVariableDeclaration)this.parameters.get(i);
            SingleVariableDeclaration vardec2 = (SingleVariableDeclaration)wrp.parameters.get(i);
            if (!vardec1.getType().toString().equals(vardec2.getType().toString())) {
                return false;
            }
            if (!vardec1.getName().toString().equals(vardec2.getName().toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

