/*
 * Decompiled with CFR 0.152.
 */
package bicq.generic;

import bicq.generic.XAction;
import bicq.support.CodeElement;
import bicq.support.Util;
import java.util.ArrayList;
import java.util.List;
import org.jdomX.Text;

public class XSubseq
implements XAction {
    XAction start;
    XAction length;

    public XSubseq(XAction s, XAction l) {
        this.start = s;
        this.length = l;
    }

    public XSubseq(CodeElement elm) {
        List elms = elm.getChildren();
        if (elms.size() != 2) {
            Util.throwException("The transformation arguments in xsub are not correct!");
        }
        CodeElement startElm = (CodeElement)elms.get(0);
        this.start = startElm.makeAction();
        CodeElement lenElm = (CodeElement)elms.get(1);
        this.length = lenElm.makeAction();
    }

    public List tranForward(List S) {
        List startValList = this.start.tranForward(S);
        if (startValList.size() != 1) {
            Util.throwException("The first argument of XSubseq should return one value!");
        }
        Object startValObject = startValList.get(0);
        int startVal = 0;
        if (startValObject instanceof String) {
            startVal = Integer.parseInt((String)startValObject);
        } else if (startValObject instanceof String) {
            String s = ((Text)startValObject).getValue();
            startVal = Integer.parseInt((String)startValObject);
        } else {
            Util.throwException("The first argument of xsub should return one value!");
        }
        List lengthValList = this.length.tranForward(S);
        if (lengthValList.size() != 1) {
            Util.throwException("The second argument of xsub should return one value!");
        }
        Object lengthValObject = lengthValList.get(0);
        int lengthVal = 0;
        if (lengthValObject instanceof String) {
            lengthVal = Integer.parseInt((String)lengthValObject);
        } else if (lengthValObject instanceof String) {
            String s = ((Text)lengthValObject).getValue();
            lengthVal = Integer.parseInt((String)lengthValObject);
        } else {
            Util.throwException("The second argument of xsub should return one value!");
        }
        if (lengthVal <= 0) {
            return new ArrayList();
        }
        if (startVal > 0) {
            --startVal;
        } else if (startVal == 0) {
            if (--lengthVal <= 0) {
                return new ArrayList();
            }
        } else {
            lengthVal = lengthVal + startVal - 1;
            startVal = 0;
            if (lengthVal <= 0) {
                return new ArrayList();
            }
        }
        ArrayList ValSeq = new ArrayList();
        List subseq = null;
        if (startVal + lengthVal <= S.size()) {
            subseq = S.subList(startVal, startVal + lengthVal);
        } else if (startVal < S.size()) {
            subseq = S.subList(startVal, S.size());
        }
        if (subseq != null) {
            return subseq;
        }
        return ValSeq;
    }

    public List tranBackward(List S, List V) {
        List startValList = this.start.tranForward(S);
        if (startValList.size() != 1) {
            Util.throwException("The first argument of XSubseq should return one value!");
        }
        Object startValObject = startValList.get(0);
        int startVal = 0;
        if (startValObject instanceof String) {
            startVal = Integer.parseInt((String)startValObject);
        } else if (startValObject instanceof String) {
            String s = ((Text)startValObject).getValue();
            startVal = Integer.parseInt((String)startValObject);
        } else {
            Util.throwException("The first argument of xsub should return one value!");
        }
        List lengthValList = this.length.tranForward(S);
        if (lengthValList.size() != 1) {
            Util.throwException("The second argument of xsub should return one value!");
        }
        Object lengthValObject = lengthValList.get(0);
        int lengthVal = 0;
        if (lengthValObject instanceof String) {
            lengthVal = Integer.parseInt((String)lengthValObject);
        } else if (lengthValObject instanceof String) {
            String s = ((Text)lengthValObject).getValue();
            lengthVal = Integer.parseInt((String)lengthValObject);
        } else {
            Util.throwException("The second argument of xsub should return one value!");
        }
        if (startVal > 0) {
            --startVal;
        } else if (startVal == 0) {
            --lengthVal;
        } else {
            lengthVal = lengthVal + startVal - 1;
            startVal = 0;
        }
        if (lengthVal <= 0) {
            ArrayList ValSeq = new ArrayList();
            ValSeq.addAll(S);
            if (startVal < S.size()) {
                ValSeq.addAll(startVal, V);
            } else {
                ValSeq.addAll(V);
            }
            return ValSeq;
        }
        List headPart = null;
        if (startVal <= S.size()) {
            headPart = S.subList(0, startVal);
        } else if (startVal > S.size()) {
            headPart = S.subList(0, S.size());
        }
        List tailPart = null;
        if (startVal + lengthVal <= S.size()) {
            tailPart = S.subList(startVal + lengthVal, S.size());
        }
        ArrayList ValSeq = new ArrayList();
        if (headPart != null) {
            ValSeq.addAll(headPart);
        }
        ValSeq.addAll(V);
        if (tailPart != null) {
            ValSeq.addAll(tailPart);
        }
        return ValSeq;
    }
}

